@extends('auth.layouts.app')
@section('content')
    <div class="auth-bg d-flex min-vh-100 justify-content-center align-items-center">
        <div class="row g-0 justify-content-center w-100 m-xxl-5 px-xxl-4 m-3">
            <div class="col-xl-4 col-lg-5 col-md-6">
                <div class="card overflow-hidden text-center h-100 p-xxl-4 p-3 mb-0">

                    @include('auth.layouts.header')

                    <h3 class="fw-semibold mb-2">Welcome to {{ config('app.name') }}</h3>

                    <p class="text-muted mb-4"> Start your financial journey with {{ config('app.name') }}. Secure, fast, and
                        reliable banking at your fingertips.</p>

                    <form action="{{ route('register') }}" method="post" class="text-start mb-3">
                        @csrf

                        <!-- Honeypot: this field must remain empty :A honeypot is a hidden input field that humans will not fill, but bots will — so if it’s filled, we know it’s spam. -->
                        <input type="text" id="contact_time" name="contact_time" style="display:none;" tabindex="-1"
                            autocomplete="off">

                        <!-- Personal Information -->
                        <h5 class="fw-bold mb-3 mt-2 text-primary">Personal Information</h5>

                        <div class="mb-3">
                            <label class="form-label">First Name *</label>
                            <input type="text" name="name" class="form-control @error('name') is-invalid @enderror"
                                placeholder="John" value="{{ old('name') }}" required>

                            @error('name')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Middle Name</label>
                            <input type="text" name="middle_name" class="form-control @error('middle_name') @enderror"
                                placeholder="David" value="{{ old('middle_name') }}">

                            @error('middle_name')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Last Name *</label>
                            <input type="text" name="last_name"
                                class="form-control @error('last_name') is-invalid @enderror" placeholder="Smith"
                                value="{{ old('last_name') }}" required>
                            @error('last_name')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Username *</label>
                            <input type="text" name="username"
                                class="form-control @error('username') is-invalid @enderror" placeholder="johnsmith123"
                                value="{{ old('username') }}" required>
                            @error('username')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <!-- Contact Information -->
                        <h5 class="fw-bold mb-3 mt-4 text-primary">Contact Information</h5>

                        <div class="mb-3">
                            <label class="form-label">Email *</label>
                            <input type="email" name="email" class="form-control @error('email') is-invalid @enderror"
                                placeholder="john@example.com" value="{{ old('email') }}" required>
                            @error('email')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Phone *</label>
                            <input type="tel" name="phone" class="form-control @error('phone') is-invalid @enderror"
                                placeholder="+1 (234) 567-8901" value="{{ old('phone') }}" required>
                            @error('phone')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Country *</label>
                            <select name="country" class="form-select @error('country') is-invalid @enderror" required>
                                <option value="">Select Country</option>
                                @foreach (config('setting.countries') as $key => $country)
                                    <option value="{{ $country }}" @selected(old('country') == $country)>
                                        {{ $country }}
                                    </option>
                                @endforeach
                            </select>
                            @error('country')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <!-- Account Setup -->
                        <h5 class="fw-bold mb-3 mt-4 text-primary">Account Setup</h5>

                        <div class="mb-3">
                            <label class="form-label">Currency *</label>
                            <select name="currency" class="form-select @error('currency') is-invalid @enderror" required>
                                <option value="">Select Currency</option>
                                @foreach (config('setting.currencies') as $key => $currency)
                                    <option
                                        value="{{ $currency['name'] }}-{{ $currency['code'] }}-{{ $currency['symbol'] }}"
                                        {{ old('currency') == $currency['name'] . '-' . $currency['code'] . '-' . $currency['symbol'] ? 'selected' : '' }}>
                                        {{ $currency['name'] }}</option>
                                @endforeach
                            </select>
                            @error('currency')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Account Type *</label>
                            <select name="account_type" class="form-select @error('account_type') is-invalid @enderror"
                                required>
                                <option value="">Select Account Type</option>
                                @foreach (config('setting.accountTypes') as $accountType)
                                    <option value="{{ $accountType }}" @selected(old('account_type') == $accountType)>
                                        {{ $accountType }}</option>
                                @endforeach
                            </select>
                            @error('account_type')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Transaction PIN *</label>
                            <input type="password" name="transaction_pin" maxlength="4"
                                class="form-control @error('transaction_pin') is-invalid @enderror"
                                placeholder="4-digit PIN" required>
                            @error('transaction_pin')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <!-- Security Setup -->
                        <h5 class="fw-bold mb-3 mt-4 text-primary">Security Setup</h5>

                        <div class="mb-3">
                            <label class="form-label">Password *</label>
                            <input type="password" name="password"
                                class="form-control @error('password') is-invalid @enderror"
                                placeholder="Create strong password" required>
                            @error('password')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Confirm Password *</label>
                            <input type="password" name="password_confirmation"
                                class="form-control @error('password_confirmation') is-invalid @enderror"
                                placeholder="Confirm your password" required>

                            @error('password_confirmation')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="d-grid mt-3">
                            <button type="submit" class="btn btn-primary">Create Account</button>
                        </div>
                    </form>

                    <p class="text-danger fs-14 mb-4">Already have an account? <a href="{{ route('login') }}"
                            class="fw-semibold text-dark ms-1">Login !</a></p>

                    @include('auth.layouts.footer')
                </div>
            </div>
        </div>
    </div>
@endsection
