@extends('auth.layouts.app')
@section('content')
    <div class="auth-bg d-flex min-vh-100 justify-content-center align-items-center">
        <div class="row g-0 justify-content-center w-100 m-xxl-5 px-xxl-4 m-3">
            <div class="col-xl-4 col-lg-5 col-md-6">
                <div class="card overflow-hidden text-center h-100 p-xxl-4 p-3 mb-0">
                    @include('auth.layouts.header')

                    <h3 class="fw-semibold mb-2">Two-Factor Authentication</h3>

                    <p class="text-muted mb-4">Enter the 6-digit code sent to your email</p>

                    <form method="POST" action="{{ route('two_factor_authentication', ['id' => $user->uuid]) }}"
                        class="text-start mb-3">
                        @csrf

                        <div class="mb-3">
                            <label class="form-label" for="verification_code">Verification
                                Code</label>
                            <input type="text" id="verification_code" name="verification_code"
                                class="form-control text-center @error('verification_code') is-invalid @enderror"
                                placeholder="XXXXXX" maxlength="6" autocomplete="off" required>

                            @error('verification_code')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary">Verify and Login</button>
                        </div>
                    </form>

                    <!-- Help Section -->
                    <div class="mt-4 p-4 bg-light rounded-3 border">
                        <h5 class="fw-semibold mb-3 text-dark d-flex align-items-center">
                            <i class="fas fa-question-circle me-2 text-primary"></i>
                            Didn't get the code?
                        </h5>
                        <ul class="list-unstyled small text-muted mb-0">
                            <li class="d-flex align-items-center mb-1">
                                <i class="fas fa-dot-circle me-2 text-secondary"></i>
                                Check your spam folder
                            </li>
                            <li class="d-flex align-items-center mb-1">
                                <i class="fas fa-dot-circle me-2 text-secondary"></i>
                                Code expires after 60 minutes
                            </li>
                            <li class="d-flex align-items-center">
                                <i class="fas fa-dot-circle me-2 text-secondary"></i>
                                Verify your email address
                            </li>
                        </ul>
                    </div>

                    <!-- Action Buttons -->
                    <div class="mt-4 mb-4">
                        <!-- Resend Verification -->
                        <form action="{{ route('two_factor_authentication.send', ['id' => $user->uuid]) }}" method="POST" class="mb-3">
                            @csrf

                            <button type="submit"
                                class="btn btn-outline-secondary w-100 d-flex align-items-center justify-content-center"
                                wire:loading.attr="disabled">
                                <i class="fas fa-redo me-2"></i> Resend Verification Code
                            </button>
                        </form>
                    </div>

                    @include('auth.layouts.footer')
                </div>
            </div>
        </div>
    </div>
@endsection
