@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.admin.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            @include('dashboard.admin.user.partials.account_options_and_status')

            <div class="col-lg-12">
                <x-dashboard.admin.card>
                    @slot('header')
                        {{ $title }}
                    @endslot

                    <div class="table-responsive">
                        <table id="myTable" class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Reference ID</th>
                                    <th>Amount</th>
                                    <th>Type</th>
                                    <th>Balance</th>
                                    <th>Description</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($transactions as $transaction)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $transaction->reference_id }}</td>
                                        <td>
                                            @if ($transaction->isDirectionCredit())
                                                <span
                                                    class="text-success">+{{ currency($user->currency) }}{{ formatAmount($transaction->amount) }}</span>
                                            @else
                                                <span
                                                    class="text-danger">-{{ currency($user->currency) }}{{ formatAmount($transaction->amount) }}</span>
                                            @endif
                                        </td>
                                        <td>{{ $transaction->type->label() }}</td>
                                        <td>{{ currency($user->currency) }}{{ formatAmount($transaction->current_balance) }}
                                        </td>
                                        <td>{{ $transaction->description }}</td>
                                        <td>{{ formatDateTime($transaction->transaction_at) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot class="thead-dark">
                                <tr>
                                    <td colspan="4"><strong>*** Totals ***</strong></td>
                                    <td>{{ currency($user->currency) }}{{ formatAmount($totalAmount) }}</td>
                                    <td></td>
                                    <td></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>

                </x-dashboard.admin.card>
                <x-dashboard.admin.card>
                    <div class="d-flex justify-content-end">
                        <a href="{{ route('admin.user.account_statement.download', [$user->uuid, $from, $to]) }}"
                            class="btn btn-dark m-1">
                            <i class="bi bi-printer me-1"></i> Print Receipt
                        </a>

                        <a href="{{ route('admin.user.account_statement.index', $user->uuid) }}"
                            class="btn btn-primary m-1">
                            <i class="ti ti-arrow-left me-1"></i> Back</a>
                    </div>
                </x-dashboard.admin.card>

            </div>
            <!-- end col -->
        </div>
        <!-- end row -->

    </div>
@endsection
