<!DOCTYPE html>
<html lang="en" x-data="{ darkMode: false, mobileMenuOpen: false }" x-init="darkMode = localStorage.getItem('darkMode') === 'true' || (!localStorage.getItem('darkMode') && window.matchMedia('(prefers-color-scheme: dark)').matches)" :class="{ 'dark': darkMode }">

    <head>
        <title><?php echo e($title); ?> - <?php echo e(config('app.name')); ?></title>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        <meta name="robots" content="index, follow">
        <meta name="apple-mobile-web-app-title" content="<?php echo e(config('app.name')); ?>">
        <meta name="application-name" content="<?php echo e(config('app.name')); ?>">
        <meta name="description" content="<?php echo e(config('app.meta.description')); ?>">
        <meta property="og:type" content="website" />
        <meta property="og:image" content="<?php echo e(asset(config('app.assets.og_image'))); ?>" />
        <link rel="shortcut icon" href="<?php echo e(asset(config('app.assets.favicon'))); ?>">

        <?php echo $__env->make('frontend.layouts.partials.dark_mode_initialization', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <?php echo $__env->make('frontend.layouts.partials.tailwind_custom_color_variables', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <!-- Alpine.js -->
        <script defer src="/frontend/cdn.jsdelivr.net/npm/alpinejs%403.x.x/dist/cdn.min.js"></script>

        <!-- Font Awesome -->
        <link rel="stylesheet" href="/frontend/cdn.jsdelivr.net/gh/aquawolf04/font-awesome-pro%405cd1511/css/all.css">

        <!-- External Fonts -->
        <link rel="preconnect" href="https://fonts.googleapis.com/">
        <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800;900&amp;display=swap"
            rel="stylesheet">

        <?php echo $__env->make('frontend.layouts.partials.style', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <?php echo $__env->make('partials.google_translator', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </head>

    <body class="font-sans bg-white dark:bg-gray-900 text-gray-900 dark:text-gray-100">

        <?php echo $__env->make('frontend.layouts.partials.mobile_fixed_login_register_button', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <?php echo $__env->make('frontend.layouts.nav', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <?php echo $__env->yieldContent('content'); ?>

        <?php echo $__env->make('frontend.layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        

        <?php echo $__env->make('frontend.layouts.partials.additional_script', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <?php echo $__env->make('frontend.layouts.partials.language_translation_script', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <?php echo $__env->make('partials.live_chat', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </body>

</html>
<?php /**PATH C:\xampp\htdocs\projects\online-banking-v7.0\resources\views/frontend/layouts/app.blade.php ENDPATH**/ ?>