 <!-- Right Side - Password Reset Form -->
 <div
     class="w-full lg:w-1/2 flex flex-col justify-center items-center p-3 lg:p-8 bg-gray-50/50 dark:bg-gray-900/50 backdrop-blur-sm">
     <div class="w-full max-w-sm">
         <!-- Mobile Header -->
         <div class="lg:hidden text-center mb-6">
             <div class="relative inline-block mb-3 mt-10">
                 <div class="absolute inset-0 bg-primary-500/20 rounded-2xl blur-lg"></div>
                 <div
                     class="relative bg-white/90 dark:bg-gray-800/90 backdrop-blur-sm rounded-2xl p-3 border border-gray-200/50 dark:border-gray-700/50">
                     <img src="<?php echo e(asset(config('app.assets.logo'))); ?>" alt="Logo" class="h-10 mx-auto">
                 </div>
             </div>
             <h1 class="text-xl font-bold text-gray-900 dark:text-white mb-1">Create New Password</h1>
             <p class="text-sm text-gray-600 dark:text-gray-400">Enter your email and new password to reset your account
             </p>
         </div>

         <!-- Enhanced Alerts -->
         <?php echo $__env->make('partials.tailwind_alert', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

         <!-- Enhanced Password Reset Card -->
         <div
             class="bg-white/90 dark:bg-gray-800/90 backdrop-blur-xl rounded-2xl shadow-2xl border border-gray-200/50 dark:border-gray-700/50 overflow-hidden">
             <!-- Card Header -->
             <div class="px-6 pt-6 pb-4 border-b border-gray-100/50 dark:border-gray-700/50 text-center">
                 <div
                     class="inline-flex items-center justify-center w-16 h-16 rounded-2xl bg-primary-100/50 dark:bg-primary-800/50 backdrop-blur-sm mb-4">
                     <i class="fas fa-lock text-2xl text-primary-600 dark:text-primary-300"></i>
                 </div>
                 <h2 class="text-xl font-bold text-gray-900 dark:text-white mb-1">Create New Password</h2>
                 <p class="text-sm text-gray-600 dark:text-gray-400">Enter your email and new password to reset your
                     account</p>
             </div>

             <!-- Password Reset Form -->
             <div class="px-6 pb-6 pt-4">
                 <form method="POST" action="<?php echo e(route('password.store')); ?>" class="space-y-4">
                     <?php echo csrf_field(); ?>
                     <!-- Password Reset Token -->
                     <input type="hidden" name="token" value="<?php echo e($request->route('token')); ?>">
                     <!-- Email Field -->
                     <div class="space-y-1">
                         <label for="email"
                             class="block text-xs font-semibold text-gray-700 dark:text-gray-300">Email
                             Address</label>
                         <div class="input-wrapper group">
                             <div class="relative">
                                 <div class="input-icon group-focus-within:text-primary-500 transition-colors z-10">
                                     <i class="fas fa-envelope text-sm"></i>
                                 </div>
                                 <input id="email" type="email" name="email"
                                     value="<?php echo e(old('email', $request->email)); ?>"
                                     class="w-full pl-10 pr-3 py-3 border border-gray-300/50 dark:border-gray-600/50 rounded-xl bg-gray-50/50 dark:bg-gray-700/50 text-gray-900 dark:text-gray-100 placeholder-gray-500 dark:placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-primary-500/50 focus:border-primary-500 backdrop-blur-sm transition-all duration-300 text-sm"
                                     placeholder="name@email.com" required autocomplete="email">
                             </div>
                             <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                 <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                             <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                             <?php $__errorArgs = ['token'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                 <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                             <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                         </div>
                     </div>

                     <!-- Password -->
                     <div class="space-y-1">
                         <label for="password"
                             class="block text-xs font-semibold text-gray-700 dark:text-gray-300">Password *</label>
                         <div class="relative">
                             <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none z-10">
                                 <i class="fas fa-lock text-gray-400 text-sm"></i>
                             </div>
                             <input type="password" id="password" name="password"
                                 class="w-full pl-10 pr-12 py-3 border border-gray-300/50 dark:border-gray-600/50 rounded-xl bg-gray-50/50 dark:bg-gray-700/50 text-gray-900 dark:text-gray-100 placeholder-gray-500 dark:placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-primary-500/50 focus:border-primary-500 backdrop-blur-sm transition-all duration-300 text-sm"
                                 placeholder="Create strong password" required autocomplete="new-password">
                             <button type="button" onclick="togglePassword('password')"
                                 class="absolute inset-y-0 right-0 flex items-center pr-3 text-gray-400 hover:text-primary-500 transition-colors">
                                 <i class="fas fa-eye text-sm" id="password-eye"></i>
                             </button>
                         </div>
                         <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                             <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                         <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                     </div>

                     <!-- Confirm Password -->
                     <div class="space-y-1">
                         <label for="password_confirmation"
                             class="block text-xs font-semibold text-gray-700 dark:text-gray-300">Confirm Password
                             *</label>
                         <div class="relative">
                             <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none z-10">
                                 <i class="fas fa-lock text-gray-400 text-sm"></i>
                             </div>
                             <input type="password" id="password_confirmation" name="password_confirmation"
                                 class="w-full pl-10 pr-12 py-3 border border-gray-300/50 dark:border-gray-600/50 rounded-xl bg-gray-50/50 dark:bg-gray-700/50 text-gray-900 dark:text-gray-100 placeholder-gray-500 dark:placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-primary-500/50 focus:border-primary-500 backdrop-blur-sm transition-all duration-300 text-sm"
                                 placeholder="Confirm your password" required autocomplete="new-password">
                             <button type="button" onclick="togglePassword('password_confirmation')"
                                 class="absolute inset-y-0 right-0 flex items-center pr-3 text-gray-400 hover:text-primary-500 transition-colors">
                                 <i class="fas fa-eye text-sm" id="password_confirmation-eye"></i>
                             </button>
                         </div>
                     </div>

                     <!-- Submit Button -->
                     <div class="pt-2">
                         <button type="submit"
                             class="w-full py-3 px-4 bg-gradient-to-r from-primary-600 to-primary-700 hover:from-primary-700 hover:to-primary-800 dark:from-primary-700 dark:to-primary-800 dark:hover:from-primary-600 dark:hover:to-primary-700 text-white font-semibold rounded-xl shadow-lg hover:shadow-xl transform hover:scale-[1.02] transition-all duration-300 flex items-center justify-center group text-sm">
                             <i
                                 class="fas fa-paper-plane mr-2 group-hover:translate-x-1 transition-transform text-sm"></i>
                             <span>Create New Password</span>
                         </button>
                     </div>

                     <!-- Back to Login -->
                     <div class="pt-1">
                         <a href="<?php echo e(route('login')); ?>"
                             class="w-full py-3 px-4 bg-gray-100/90 dark:bg-gray-700/90 hover:bg-gray-200/90 dark:hover:bg-gray-600/90 text-gray-800 dark:text-gray-200 font-medium rounded-xl transition-all duration-300 flex items-center justify-center group text-sm backdrop-blur-sm border border-gray-200/50 dark:border-gray-600/50">
                             <i
                                 class="fas fa-sign-in-alt mr-2 group-hover:-translate-x-1 transition-transform text-sm"></i>
                             Return to Login
                         </a>
                     </div>
                 </form>
             </div>
         </div>

         <!-- Footer -->
         <div class="mt-6 text-center">
             <p class="text-xs text-gray-500 dark:text-gray-500 max-w-xs mx-auto leading-relaxed">
                 &copy; <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?>. All Rights Reserved.
             </p>
         </div>
     </div>
 </div>
<?php /**PATH C:\xampp\htdocs\projects\online-banking-v7.0\resources\views/auth/sections/reset_password/right_side.blade.php ENDPATH**/ ?>