<div>
    <div class="card">
        <div class="card-body">
            <div class="container-fluid mb-4">
                <div class="row g-4">
                    <!-- Available -->
                    <div class="col-12 col-md-6 col-lg-3">
                        <div class="card shadow-sm border rounded-3 h-100">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div class="d-flex align-items-center justify-content-center bg-primary rounded p-2"
                                        style="width:40px; height:40px;">
                                        <i class="fa-solid fa-credit-card text-white"></i>
                                    </div>
                                    <span
                                        class="text-muted small fw-medium"><?php echo e(currency(Auth::user()->currency)); ?></span>
                                </div>
                                <h3 class="h5 fw-bold mb-1">
                                    <?php echo e(currency(Auth::user()->currency)); ?><?php echo e(formatAmount(Auth::user()->account_balance, 2)); ?>

                                </h3>

                            </div>
                        </div>
                    </div>

                    <!-- Monthly Deposits -->
                    <div class="col-12 col-md-6 col-lg-3">
                        <div class="card shadow-sm border rounded-3 h-100">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div class="d-flex align-items-center justify-content-center bg-success rounded p-2"
                                        style="width:40px; height:40px;">
                                        <i class="fab fa-bitcoin text-white"></i>
                                    </div>
                                    <span class="text-muted small fw-medium">BITCOIN</span>
                                </div>
                                <h3 class="h5 fw-bold mb-1"><?php echo e(formatAmount(Auth::user()->bitcoin_balance, 8)); ?> BTC
                                </h3>

                            </div>
                        </div>
                    </div>

                    <!-- Monthly Expenses -->
                    <div class="col-12 col-md-6 col-lg-3">
                        <div class="card shadow-sm border rounded-3 h-100">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div class="d-flex align-items-center justify-content-center bg-danger rounded p-2"
                                        style="width:40px; height:40px;">
                                        <i class="fab fa-ethereum text-white"></i>
                                    </div>
                                    <span class="text-muted small fw-medium">ETHEREUM</span>
                                </div>
                                <h3 class="h5 fw-bold mb-1"><?php echo e(formatAmount(Auth::user()->ethereum_balance, 8)); ?> ETH
                                </h3>

                            </div>
                        </div>
                    </div>

                </div>
            </div>

            <?php echo $__env->make('partials.bootstrap_alert', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <form wire:submit.prevent="swap">
                <div class="mb-3">
                    <label class="form-label">From Currency</label>
                    <select wire:model.live="fromCurrency" class="form-select">
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $availableCurrencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <!--[if BLOCK]><![endif]--><?php if($currency !== $toCurrency): ?>
                                <option value="<?php echo e($currency); ?>">
                                    <!--[if BLOCK]><![endif]--><?php if($currency === 'BTC'): ?>
                                        Bitcoin (BTC)
                                    <?php elseif($currency === 'ETH'): ?>
                                        Ethereum (ETH)
                                    <?php else: ?>
                                        <?php echo e($currency); ?>

                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </option>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </select>
                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['fromCurrency'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <small class="text-danger"><?php echo e($message); ?></small>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->

                </div>

                <div class="mb-3">
                    <label class="form-label">To Currency</label>
                    <select wire:model.live="toCurrency" class="form-select">
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $availableCurrencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <!--[if BLOCK]><![endif]--><?php if($currency !== $fromCurrency): ?>
                                <option value="<?php echo e($currency); ?>">
                                    <!--[if BLOCK]><![endif]--><?php if($currency === 'BTC'): ?>
                                        Bitcoin (BTC)
                                    <?php elseif($currency === 'ETH'): ?>
                                        Ethereum (ETH)
                                    <?php else: ?>
                                        <?php echo e($currency); ?>

                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </option>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </select>
                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['toCurrency'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <small class="text-danger"><?php echo e($message); ?></small>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                </div>

                <div class="mb-3">
                    <label class="form-label">Amount</label>
                    <div class="input-group">
                        <input type="number" wire:model.live.debounce.500ms="amount" class="form-control"
                            step="any" min="0" placeholder="Enter amount to swap">
                        <span class="input-group-text"><?php echo e($fromCurrency); ?></span>
                    </div>
                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <small class="text-danger"><?php echo e($message); ?></small>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                </div>

                <div class="mb-3">
                    <label class="form-label">Estimated Conversion</label>
                    <div class="row">
                        <div class="col">
                            <div class="input-group">
                                <span class="input-group-text">From:</span>
                                <input type="text" class="form-control" readonly
                                    value="<?php echo e(formatAmount($amount, $fromCurrency == 'BTC' || $fromCurrency == 'ETH' ? 8 : 2)); ?> <?php echo e($fromCurrency); ?>">
                            </div>
                        </div>
                        <div class="col-auto d-flex align-items-center">
                            <i class="fas fa-arrow-right"></i>
                        </div>
                        <div class="col">
                            <div class="input-group">
                                <span class="input-group-text">To:</span>
                                <input type="text" class="form-control" readonly
                                    value="<?php echo e(formatAmount($estimatedAmount, $toCurrency == 'BTC' || $toCurrency == 'ETH' ? 8 : 2)); ?> <?php echo e($toCurrency); ?>">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="text-end">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-exchange-alt me-2"></i>Swap Currencies
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php /**PATH C:\xampp\htdocs\projects\online-banking-v7.0\resources\views/livewire/dashboard/currency-swap.blade.php ENDPATH**/ ?>