<div class="d-flex justify-content-center mb-5">
    <div class="card shadow-sm border-0 text-center p-4" style="max-width: 22rem;">

        <!-- Icon -->
        <div class="d-flex align-items-center justify-content-center">
            <div class="d-flex align-items-center justify-content-center bg-primary rounded-3 mb-3"
                style="width: 3rem; height: 3rem;">
                <i class="fas fa-qrcode text-white"></i>
            </div>
        </div>

        <!-- Title -->
        <h5 class="fw-semibold mb-3">Scan QR Code</h5>

        <?php if(!$wallet->qr_code_path): ?>
            <!-- QR Code -->
            <div class="bg-light border rounded-3 p-3 mb-3 d-flex justify-content-center">
                

                <img src="https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=<?php echo e($wallet->address); ?>?amount=<?php echo e($deposit->amount); ?>"
                    alt="Payment QR Code" class="img-fluid rounded" style="max-width: 11rem;">
            </div>
        <?php else: ?>
            <!-- QR Code -->
            <div class="bg-light border rounded-3 p-3 mb-3 d-flex justify-content-center">
                <img src="<?php echo e(asset($wallet->qr_code_path)); ?>" alt="Payment QR Code" class="img-fluid rounded"
                    style="max-width: 11rem;">
            </div>
        <?php endif; ?>

        <!-- Note -->
        <p class="text-muted small mb-3">Scan with your payment app</p>

        <!-- Address and Amount -->
        <div class="w-100">
            <div class="mb-3">
                <p class="small fw-medium mb-1">Bitcoin Address:</p>
                <p class="small text-muted bg-light p-2 rounded break-word">
                    <?php echo e($wallet->address); ?>

                </p>
            </div>
            <div>
                <p class="small fw-medium mb-1">Amount:</p>
                <p class="small fw-semibold text-dark">
                    <?php echo e(currency($deposit->user->currency)); ?><?php echo e(formatAmount($deposit->amount)); ?></p>
            </div>
        </div>

    </div>
</div>

<?php if (isset($component)) { $__componentOriginal66cb34fa521ca32c539059e04f66064d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal66cb34fa521ca32c539059e04f66064d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.user.card','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.user.card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <form action="<?php echo e(route('user.deposit.payment', $deposit->reference_id)); ?>" method="post"
        enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PATCH'); ?>
        <div class="mb-3">
            <label for="bitcoin_address" class="form-label"> <i class="fa-solid fa-credit-card"></i>
                Bitcoin Address *</label>
            <div class="input-group">
                <input type="text" id="bitcoin_address" name="bitcoin_address" class="form-control"
                    value="<?php echo e($wallet->address); ?>" readonly>
                <button type="button" class="btn btn-outline-secondary" onclick="copyToClipboard('bitcoin_address')"
                    title="Copy address">
                    <i class="ti ti-copy"></i>
                </button>
            </div>
            <small>
                Network Type: <?php echo e($wallet->network); ?></small>
        </div>

        <div class="mb-3">
            <label for="payment_proof" class="form-label">Upload Payment Proof</label>
            <input type="file" id="payment_proof" name="payment_proof"
                class="form-control <?php $__errorArgs = ['payment_proof'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" accept=".jpg,.jpeg,.png">
            <?php $__errorArgs = ['payment_proof'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="invalid-feedback"><?php echo e($message); ?></span>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <?php if (isset($component)) { $__componentOriginal3da7c2b1a70c514618cac6445fff8846 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3da7c2b1a70c514618cac6445fff8846 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.user.form-button','data' => ['class' => 'btn btn-primary','icon' => 'fa-solid fa-check-circle me-1','name' => 'Submit Payment']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.user.form-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'btn btn-primary','icon' => 'fa-solid fa-check-circle me-1','name' => 'Submit Payment']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3da7c2b1a70c514618cac6445fff8846)): ?>
<?php $attributes = $__attributesOriginal3da7c2b1a70c514618cac6445fff8846; ?>
<?php unset($__attributesOriginal3da7c2b1a70c514618cac6445fff8846); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3da7c2b1a70c514618cac6445fff8846)): ?>
<?php $component = $__componentOriginal3da7c2b1a70c514618cac6445fff8846; ?>
<?php unset($__componentOriginal3da7c2b1a70c514618cac6445fff8846); ?>
<?php endif; ?>

    </form>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal66cb34fa521ca32c539059e04f66064d)): ?>
<?php $attributes = $__attributesOriginal66cb34fa521ca32c539059e04f66064d; ?>
<?php unset($__attributesOriginal66cb34fa521ca32c539059e04f66064d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal66cb34fa521ca32c539059e04f66064d)): ?>
<?php $component = $__componentOriginal66cb34fa521ca32c539059e04f66064d; ?>
<?php unset($__componentOriginal66cb34fa521ca32c539059e04f66064d); ?>
<?php endif; ?>
<?php /**PATH C:\xampp\htdocs\projects\online-banking-v7.0\resources\views/dashboard/user/partials/bitcoin_payment.blade.php ENDPATH**/ ?>