<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="utf-8" />
        <title><?php echo e($title); ?> &mdash; <?php echo e(config('app.name')); ?></title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta content="<?php echo e(config('app.meta.keywords')); ?>" name="keywords">
        <meta content="<?php echo e(config('app.meta.description')); ?>" name="description">
        <meta property="og:title" content="<?php echo e(config('app.name')); ?> - <?php echo e(config('app.slogan')); ?>" />
        <meta property="og:type" content="website" />
        <meta property="og:url" content="<?php echo e(url()->current()); ?>" />
        <meta property="og:image" content="<?php echo e(asset(config('app.assets.og_image'))); ?>" />

        <!-- App favicon -->
        <link rel="shortcut icon" href="<?php echo e(asset(config('app.assets.favicon'))); ?>">

        <!-- Theme Config Js -->
        <script src="/dashboard/assets/js/config.js"></script>

        <!-- Vendor css -->
        <link href="/dashboard/assets/css/vendor.min.css" rel="stylesheet" type="text/css" />

        <!-- App css -->
        <link href="/dashboard/assets/css/app.min.css" rel="stylesheet" type="text/css" id="app-style" />

        <!-- Icons css -->
        <link href="/dashboard/assets/css/icons.min.css" rel="stylesheet" type="text/css" />

        <?php echo $__env->make('partials.google_translator', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <script src="/assets/js/sweet_alert2.js"></script>
    </head>

    <body>

        <?php echo $__env->yieldContent('content'); ?>

        <!-- Vendor js -->
        <script src="/dashboard/assets/js/vendor.min.js"></script>

        <!-- App js -->
        <script src="/dashboard/assets/js/app.js"></script>

        <?php echo $__env->make('partials.live_chat', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </body>

</html>
<?php /**PATH C:\xampp\htdocs\projects\online-banking-v7.2\resources\views/auth/layouts/app.blade.php ENDPATH**/ ?>