
<!DOCTYPE html>
<html class="wide wow-animation" lang="en">

    <meta http-equiv="content-type" content="text/html;charset=UTF-8" />

    <head>
        <meta charset="UTF-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="viewport"
            content="width=device-width, height=device-height, initial-scale=1.0, maximum-scale=1.0, user-scalable=0" />

        <title><?php echo e($title); ?> &mdash; <?php echo e(config('app.name')); ?></title>
        <!-- Description -->
        <meta
            content="Online Banking, Internet Banking, Secure Banking, Financial Management, Fund Transfer, Bill Payments, 24/7 Access, Digital Banking, Personalized Banking"
            name="keywords">
        <meta
            content="Experience secure and convenient online banking with our platform. Manage your finances, transfer funds, and enjoy 24/7 access to your accounts. Explore our advanced features for a seamless and personalized banking experience."
            name="description">
        <meta property="og:title" content="<?php echo e(config('app.name')); ?> - Secure Online Banking" />
        <meta property="og:type" content="website" />
        <meta property="og:url" content="<?php echo e(url()->current()); ?>" />
        <meta property="og:image" content="<?php echo e(asset(config('app.assets.og_image'))); ?>" />

        <!-- Favicon -->
        <link rel="shortcut icon" href="<?php echo e(asset(config('app.assets.favicon'))); ?>">

        <!-- Stylesheets-->
        <link rel="stylesheet" type="text/css"
            href="http://fonts.googleapis.com/css?family=Roboto:100,300,300i,400,700,900" />

        <link rel="stylesheet" href="/frontend/assets/bankAsset/css/bootstrap.css" />

        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

        <link rel="stylesheet" href="/frontend/assets/bankAsset/css/style.css" id="main-styles-link" />

        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

        
        <?php echo $__env->make('partials.google_translator', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <style>
            .fixed {
                position: fixed;
                bottom: 10px;
                right: 40px;
                background-color: #fff;
                border-radius: 50%;
                width: fit-content;
                padding: 1rem;
                z-index: 11111111111;
                cursor: pointer;
                box-shadow: 0 0 5px 0px #000;
                /* display: none; */
            }

            /* .fixed:hover {
            background-color: #eee;
        } */
        </style>
    </head>

    <body>

        <?php echo $__env->make('frontend.layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <?php echo $__env->make('partials.sweet_alert', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <?php echo $__env->yieldContent('content'); ?>

        <?php echo $__env->make('frontend.layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <!-- Global Mailform Output-->
        <div class="snackbars" id="form-output-global"></div>
        <!-- Javascript-->

        <!-- Alertify JS -->
        <script src="/frontend/assets/bankAsset/js/core.min.js"></script>
        <script src="/frontend/assets/bankAsset/js/script.js"></script>

        <?php echo $__env->make('partials.live_chat', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </body>

</html>
<?php /**PATH C:\xampp\htdocs\projects\online-banking-v7.2\resources\views/frontend/layouts/app.blade.php ENDPATH**/ ?>