
<?php $__env->startSection('content'); ?>
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0"><?php echo e($title); ?></h4>
            </div>

            <div class="text-end">
                <?php if (isset($component)) { $__componentOriginalf249638ac7504c50bf0259c0cb71919d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf249638ac7504c50bf0259c0cb71919d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.user.breadcrumbs','data' => ['breadcrumbs' => $breadcrumbs]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.user.breadcrumbs'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['breadcrumbs' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($breadcrumbs)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf249638ac7504c50bf0259c0cb71919d)): ?>
<?php $attributes = $__attributesOriginalf249638ac7504c50bf0259c0cb71919d; ?>
<?php unset($__attributesOriginalf249638ac7504c50bf0259c0cb71919d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf249638ac7504c50bf0259c0cb71919d)): ?>
<?php $component = $__componentOriginalf249638ac7504c50bf0259c0cb71919d; ?>
<?php unset($__componentOriginalf249638ac7504c50bf0259c0cb71919d); ?>
<?php endif; ?>
            </div>
        </div>

        <div class="row">
            <div class="col-xl-4 col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex align-items-center gap-2">
                            <?php if($user->image): ?>
                                <a href="<?php echo e(asset($user->image)); ?>" target="_blank"><img src="<?php echo e(asset($user->image)); ?>"
                                        class="avatar-xl rounded-circle border border-light border-2"></a>
                            <?php else: ?>
                                <img src="<?php echo e(asset('assets/images/avatar.png')); ?>"
                                    class="avatar-xl rounded-circle border border-light border-2">
                            <?php endif; ?>
                            <div>
                                <h4 class="text-dark fw-medium"><?php echo e($user->name); ?> <?php echo e($user->first_name); ?>

                                    <?php echo e($user->last_name); ?></h4>
                                <p class="mb-0 text-muted">Account Number: <?php echo e($user->account_number); ?></p>
                                <p class="mb-0 text-muted">Account State:
                                    <span class="<?php echo e($user->account_state->badge()); ?>">
                                        <?php echo e($user->account_state->label()); ?>

                                    </span>
                                </p>
                            </div>
                            
                        </div>
                        <div class="mt-3">
                            <h4 class="fs-15">Contact Details :</h4>
                            <div class="mt-3">
                                <div class="d-flex align-items-center gap-2 mb-2">
                                    <div class="bg-opacity-75 d-flex align-items-center justify-content-center rounded">
                                        <iconify-icon icon="solar:point-on-map-bold-duotone"
                                            class="fs-20 text-primary"></iconify-icon>
                                    </div>
                                    <p class="mb-0 text-dark"><?php echo e($user->address); ?>, <?php echo e($user->state); ?>,
                                        <?php echo e($user->country); ?></p>
                                </div>
                                <div class="d-flex align-items-center gap-2 mb-2">
                                    <div class="bg-opacity-75 d-flex align-items-center justify-content-center rounded">
                                        <iconify-icon icon="solar:smartphone-2-bold-duotone"
                                            class="fs-20 text-primary"></iconify-icon>
                                    </div>
                                    <p class="mb-0 text-dark"><?php echo e($user->phone); ?></p>
                                </div>
                                <div class="d-flex align-items-center gap-2">
                                    <div class="bg-opacity-75 d-flex align-items-center justify-content-center rounded">
                                        <iconify-icon icon="solar:letter-bold-duotone"
                                            class="fs-20 text-primary"></iconify-icon>
                                    </div>
                                    <p class="mb-0 text-dark"><?php echo e($user->email); ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="mt-3">
                            <h4 class="fs-15">Account Details :</h4>
                            <p class="mb-0 text-muted fs-14 mt-2">Account Type: <?php echo e($user->account_type); ?>,
                                Employment Type: <?php echo e($user->employment); ?></p>
                        </div>
                    </div>
                    <div class="card-footer border-top border-dashed">
                        <div class="list-group list-group-flush">
                            <a href="<?php echo e(route('user.profile.change_image')); ?>"
                                class="list-group-item list-group-item-action d-flex align-items-center">
                                <i class="ti ti-photo text-primary me-2 fs-5"></i>
                                <div>
                                    <div class="fw-bold">Change Profile Image</div>
                                    <small class="text-muted">Update your account photo for better personalization</small>
                                </div>
                            </a>

                            <a href="<?php echo e(route('user.profile.change_password')); ?>"
                                class="list-group-item list-group-item-action d-flex align-items-center">
                                <i class="ti ti-lock text-warning me-2 fs-5"></i>
                                <div>
                                    <div class="fw-bold">Password Settings</div>
                                    <small class="text-muted">Manage your login password and keep your account
                                        secure</small>
                                </div>
                            </a>

                            <a href="<?php echo e(route('user.profile.two_factor_authentication')); ?>"
                                class="list-group-item list-group-item-action d-flex align-items-center">
                                <i class="ti ti-shield-lock text-success me-2 fs-5"></i>
                                <div class="d-flex flex-column">
                                    <div class="fw-bold">
                                        Two-Factor Authentication <?php echo $user->two_factor_authentication->checkBadge(); ?>

                                    </div>
                                    <small class="text-muted">Add an extra layer of security to your account</small>
                                </div>
                            </a>

                            <a href="<?php echo e(route('user.profile.change_transaction_pin')); ?>"
                                class="list-group-item list-group-item-action d-flex align-items-center">
                                <i class="ti ti-key text-danger me-2 fs-5"></i>
                                <div>
                                    <div class="fw-bold">Transaction PIN</div>
                                    <small class="text-muted">Set or update your PIN for financial transactions</small>
                                </div>
                            </a>
                        </div>
                    </div>

                </div>

                <div class="card">
                    <div class="card-header border-bottom border-dashed">
                        <div class="d-flex align-items-center gap-2">
                            <div class="d-block">
                                <h4 class="card-title mb-0">Uploaded Documents</h4>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php if($user->front_side || $user->back_side): ?>
                            <?php if($user->front_side): ?>
                                <div
                                    class="d-flex p-2 rounded align-items-center gap-2 bg-light-subtle border border-dashed">
                                    <div
                                        class="avatar avatar-lg d-flex align-items-center justify-content-center rounded-circle">
                                        <iconify-icon icon="solar:file-download-bold"
                                            class="text-primary fs-3"></iconify-icon>
                                    </div>
                                    <div class="d-block">
                                        <a href="<?php echo e(asset($user->front_side)); ?>" target="_blank"
                                            class="text-dark fw-medium">Front Side</a>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if($user->back_side): ?>
                                <div
                                    class="d-flex p-2 rounded align-items-center gap-2 bg-light-subtle border border-dashed mt-2">
                                    <div
                                        class="avatar avatar-lg d-flex align-items-center justify-content-center rounded-circle">
                                        <iconify-icon icon="solar:file-download-bold"
                                            class="text-primary fs-3"></iconify-icon>
                                    </div>
                                    <div class="d-block">
                                        <a href="<?php echo e(asset($user->back_side)); ?>" target="_blank"
                                            class="text-dark fw-medium">Back Side</a>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php else: ?>
                            <div class="d-flex p-2 rounded align-items-center gap-2 bg-light-subtle border border-dashed">
                                <div
                                    class="avatar avatar-lg d-flex align-items-center justify-content-center rounded-circle">
                                    <iconify-icon icon="solar:file-download-bold" class="text-primary fs-3"></iconify-icon>
                                </div>
                                <div class="d-block">
                                    <p class="text-muted mb-0">No uploaded documents</p>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="card">
                    <div class="card-header d-flex align-items-center justify-content-between border-bottom border-dashed">
                        <h4 class="card-title mb-0">Account Balance</h4>
                        <div>
                            <p class="mb-0 fs-15 text-dark fw-medium">
                                <?php echo e(currency($user->currency)); ?><?php echo e(formatAmount($user->account_balance)); ?></p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-8 col-lg-12">
                <div class="card">
                    <div class="card-header border-bottom border-dashed">
                        <h4 class="card-title mb-0">User Information</h4>
                    </div>
                    <div class="card-body">

                        <?php if (isset($component)) { $__componentOriginalfe09c8749324076e07136fa94a0420b5 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalfe09c8749324076e07136fa94a0420b5 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.user.info-list','data' => ['title' => 'Account Information','options' => ['To update your personal information, please contact our customer support team.']]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.user.info-list'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Account Information','options' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(['To update your personal information, please contact our customer support team.'])]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalfe09c8749324076e07136fa94a0420b5)): ?>
<?php $attributes = $__attributesOriginalfe09c8749324076e07136fa94a0420b5; ?>
<?php unset($__attributesOriginalfe09c8749324076e07136fa94a0420b5); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalfe09c8749324076e07136fa94a0420b5)): ?>
<?php $component = $__componentOriginalfe09c8749324076e07136fa94a0420b5; ?>
<?php unset($__componentOriginalfe09c8749324076e07136fa94a0420b5); ?>
<?php endif; ?>

                        <div class="row justify-content-between align-items-center">
                            <div class="col-lg-3 col-6 border-end border-dashed">
                                <p class="text-muted mb-1">Gender</p>
                                <p class="fs-15 fw-medium mb-3"><?php echo e(str()->ucfirst($user->gender)); ?></p>
                                <p class="text-muted mb-1">Date Of Birth</p>
                                <p class="fs-15 fw-medium mb-0"><?php echo e(formatDate($user->dob)); ?></p>
                            </div>
                            <div class="col-lg-3 col-6 border-end border-dashed">
                                <p class="text-muted mb-1">Phone</p>
                                <p class="fs-15 fw-medium mb-3"><?php echo e($user->phone); ?></p>
                                <p class="text-muted mb-1">State</p>
                                <p class="fs-15 fw-medium mb-0"><?php echo e($user->state); ?></p>
                            </div>
                            <div class="col-lg-3 col-6">
                                <p class="text-muted mb-1">Address</p>
                                <p class="fs-15 fw-medium mb-3"><?php echo e($user->address); ?></p>
                                <p class="text-muted mb-1">Register Date</p>
                                <p class="fs-15 fw-medium mb-0"><?php echo e(formatDateTime($user->created_at)); ?></p>
                            </div>
                        </div>
                        <hr class="my-3">
                        <h4 class="mb-0 fs-15 fw-semibold">Additional Information :</h4>
                        <div class="row mt-2 g-2">
                            <div class="col-lg-3 col-6">
                                <h3 class="fw-medium"><?php echo e(str()->ucfirst($user->marital_status)); ?></h3>
                                <p class="mb-0 text-muted">Marital Status</p>
                            </div>
                            <div class="col-lg-3 col-6">
                                <h3 class="fw-medium"><?php echo e($user->country); ?></h3>
                                <p class="mb-0 text-muted">Nationality</p>
                            </div>
                            <div class="col-lg-3 col-6">
                                <h3 class="fw-medium"><?php echo e($user->employment); ?></h3>
                                <p class="mb-0 text-muted">Employment Type</p>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if (isset($component)) { $__componentOriginald0502abe5335291c32c2eb9debb7e492 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald0502abe5335291c32c2eb9debb7e492 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.user.support-card','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.user.support-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald0502abe5335291c32c2eb9debb7e492)): ?>
<?php $attributes = $__attributesOriginald0502abe5335291c32c2eb9debb7e492; ?>
<?php unset($__attributesOriginald0502abe5335291c32c2eb9debb7e492); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald0502abe5335291c32c2eb9debb7e492)): ?>
<?php $component = $__componentOriginald0502abe5335291c32c2eb9debb7e492; ?>
<?php unset($__componentOriginald0502abe5335291c32c2eb9debb7e492); ?>
<?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.user.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\online-banking-v7.0\resources\views/dashboard/user/profile/index.blade.php ENDPATH**/ ?>