<?php $__env->startSection('content'); ?>
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0"><?php echo e($title); ?></h4>
            </div>

            <div class="text-end">
                <?php if (isset($component)) { $__componentOriginalf249638ac7504c50bf0259c0cb71919d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf249638ac7504c50bf0259c0cb71919d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.user.breadcrumbs','data' => ['breadcrumbs' => $breadcrumbs]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.user.breadcrumbs'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['breadcrumbs' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($breadcrumbs)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf249638ac7504c50bf0259c0cb71919d)): ?>
<?php $attributes = $__attributesOriginalf249638ac7504c50bf0259c0cb71919d; ?>
<?php unset($__attributesOriginalf249638ac7504c50bf0259c0cb71919d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf249638ac7504c50bf0259c0cb71919d)): ?>
<?php $component = $__componentOriginalf249638ac7504c50bf0259c0cb71919d; ?>
<?php unset($__componentOriginalf249638ac7504c50bf0259c0cb71919d); ?>
<?php endif; ?>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header border-bottom d-flex justify-content-between align-items-center">
                        <h5 class="mb-0"><i class="bi bi-receipt"></i> Transfer Details</h5>
                        <span class="<?php echo e($transfer->status->badge()); ?>">
                            <?php echo e($transfer->status->label()); ?>

                        </span>
                    </div>
                    <div class="card-body p-4">

                        <!-- Transfer Info -->
                        <div class="row g-3 mb-4">
                            <div class="col-md-6">
                                <strong>Transaction ID:</strong>
                                <p class="mb-0 text-muted"><?php echo e($transfer->reference_id); ?></p>
                            </div>
                            <div class="col-md-6">
                                <strong>Date:</strong>
                                <p class="mb-0 text-muted"><?php echo e(formatDateTime($transfer->created_at)); ?>

                                </p>
                            </div>
                            <div class="col-md-6">
                                <strong>Transfer Type:</strong>
                                <p class="mb-0 text-muted"><?php echo e($transfer->transfer_type->fullLabel()); ?>

                                </p>
                            </div>
                            <div class="col-md-6">
                                <strong>Currency:</strong>
                                <p class="mb-0 text-muted"><?php echo e(currency($transfer->user->currency, 'code')); ?></p>
                            </div>
                        </div>

                        <!-- Beneficiary Info -->
                        <h6 class="fw-bold mb-3"><i class="bi bi-person-circle"></i> Beneficiary Information
                        </h6>
                        <div class="row g-3 mb-4">
                            <div class="col-md-6">
                                <strong>Beneficiary Name:</strong>
                                <p class="mb-0 text-muted"><?php echo e($transfer->recipient_name); ?></p>
                            </div>
                            <div class="col-md-6">
                                <strong>Account Number:</strong>
                                <p class="mb-0 text-muted"><?php echo e($transfer->recipient_account_number); ?></p>
                            </div>
                            <div class="col-md-6">
                                <strong>Bank Name:</strong>
                                <p class="mb-0 text-muted"><?php echo e($transfer->recipient_bank); ?></p>
                            </div>
                            <div class="col-md-6">
                                <strong>Account Type:</strong>
                                <p class="mb-0 text-muted"><?php echo e($transfer->recipient_account_type); ?></p>
                            </div>
                            <?php if($transfer->recipient_routing_number): ?>
                                <div class="col-md-6">
                                    <strong>Routing Number:</strong>
                                    <p class="mb-0 text-muted"><?php echo e($transfer->recipient_routing_number); ?></p>
                                </div>
                            <?php endif; ?>
                            <?php if($transfer->recipient_swift_code): ?>
                                <div class="col-md-6">
                                    <strong>SWIFT Code:</strong>
                                    <p class="mb-0 text-muted"><?php echo e($transfer->recipient_swift_code); ?></p>
                                </div>
                            <?php endif; ?>
                            <?php if($transfer->recipient_iban_code): ?>
                                <div class="col-md-6">
                                    <strong>IBAN Number:</strong>
                                    <p class="mb-0 text-muted"><?php echo e($transfer->recipient_iban_code); ?></p>
                                </div>
                            <?php endif; ?>
                        </div>

                        <!-- Transaction Amounts -->
                        <h6 class="fw-bold mb-3"><i class="bi bi-cash-stack"></i> Transaction Amount</h6>
                        <div class="row g-3 mb-4">
                            <div class="col-md-6">
                                <strong>Amount Sent:</strong>
                                <p class="mb-0 fw-bold">
                                    <?php echo e(currency($transfer->user->currency)); ?><?php echo e(formatAmount($transfer->amount)); ?>

                                </p>
                            </div>
                            
                        </div>

                        <!-- Description -->
                        <h6 class="fw-bold mb-3"><i class="bi bi-info-circle"></i> Description</h6>
                        <p class="mb-4 text-muted"><?php echo e($transfer->description ?? 'No description provided'); ?>

                        </p>

                        <!-- Action Buttons -->
                        <div class="d-flex justify-content-between">
                            <a href="<?php echo e(route('user.transfer.index')); ?>" class="btn btn-outline-secondary rounded-pill">
                                <i class="bi bi-arrow-left me-1"></i> Back to Transfers
                            </a>
                            
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.user.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\online-banking-v7.0\resources\views/dashboard/user/transfer/show.blade.php ENDPATH**/ ?>