<script>
    document.addEventListener('DOMContentLoaded', () => {
        const form = document.getElementById('updateForm');
        const messageBox = document.getElementById('updateMessage');

        if (!form) return;

        form.addEventListener('submit', async (e) => {
            e.preventDefault();
            const url = form.action;
            const formData = new FormData(form);

            // Add PUT method override for Laravel
            formData.append('_method', 'PUT');

            try {
                const response = await fetch(url, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')
                            .content,
                        'Accept': 'application/json', // Force Laravel to return JSON
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: formData
                });

                const data = await response.json(); // <-- Will fail if server returns HTML
                messageBox.innerHTML = `<div class="alert alert-success">${data.message}</div>`;

                // 🔄 Reload the page after 1.5 seconds
                setTimeout(() => {
                    location.reload();
                }, 1500);
            } catch (err) {
                // Try to show raw response if JSON parse failed
                messageBox.innerHTML = `<div class="alert alert-danger">
        ${err.message.includes('Unexpected token') ? 'Server returned HTML instead of JSON. Check route/CSRF.' : err.message}
      </div>`;
            }
        });
    });
</script>
<?php /**PATH C:\xampp\htdocs\projects\online-banking-v7.0\resources\views/dashboard/user/partials/script.blade.php ENDPATH**/ ?>